/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import net.ftb.data.ModPack;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.dialogs.SearchDialog;
import net.ftb.gui.panes.AbstractModPackPane;
import net.ftb.locale.I18N;
import net.ftb.util.SwingUtils;

public class ModPackFilterDialog
extends JDialog {
    private JLabel availabilityLbl;
    private JComboBox availability;
    private JLabel mcVersionLbl;
    private JComboBox mcVersion;
    private JButton apply;
    private JButton cancel;
    private JButton search;
    private AbstractModPackPane pane;

    public ModPackFilterDialog(AbstractModPackPane instance) {
        super((Frame)LaunchFrame.getInstance(), true);
        this.pane = instance;
        this.setupGui();
        this.getRootPane().setDefaultButton(this.apply);
        this.pane = instance;
        ArrayList<String> mcVersions = new ArrayList<String>();
        this.mcVersion.addItem(I18N.getLocaleString("MAIN_ALL"));
        mcVersions.add(I18N.getLocaleString("MAIN_ALL"));
        for (ModPack pack : ModPack.getPackArray()) {
            if (mcVersions.contains(pack.getMcVersion())) continue;
            mcVersions.add(pack.getMcVersion());
            this.mcVersion.addItem(pack.getMcVersion());
        }
        this.mcVersion.setModel(new DefaultComboBoxModel<Object>(mcVersions.toArray()));
        this.availability.setModel(new DefaultComboBoxModel<String>(new String[]{I18N.getLocaleString("MAIN_ALL"), I18N.getLocaleString("FILTER_PUBLIC"), I18N.getLocaleString("FILTER_PRIVATE")}));
        this.mcVersion.setSelectedItem(this.pane.mcVersion);
        this.availability.setSelectedItem(this.pane.avaliability);
        this.pack();
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((ModPackFilterDialog)ModPackFilterDialog.this).pane.mcVersion = (String)ModPackFilterDialog.this.mcVersion.getSelectedItem();
                ((ModPackFilterDialog)ModPackFilterDialog.this).pane.avaliability = (String)ModPackFilterDialog.this.availability.getSelectedItem();
                ModPackFilterDialog.this.pane.updateFilter();
                ModPackFilterDialog.this.setVisible(false);
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModPackFilterDialog.this.setVisible(false);
            }
        });
        this.search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SearchDialog sd = new SearchDialog(ModPackFilterDialog.this.pane);
                sd.setVisible(true);
                ModPackFilterDialog.this.setVisible(false);
            }
        });
    }

    private void setupGui() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/logo_ftb.png")));
        this.setTitle(I18N.getLocaleString("FILTER_TITLE"));
        this.setResizable(false);
        Container panel = this.getContentPane();
        SpringLayout layout = new SpringLayout();
        panel.setLayout(layout);
        this.availabilityLbl = new JLabel(I18N.getLocaleString("FILTER_MODPACKAVALIABILITY"));
        this.mcVersionLbl = new JLabel(I18N.getLocaleString("FILTER_MCVERSION"));
        this.mcVersion = new JComboBox();
        this.availability = new JComboBox();
        this.apply = new JButton(I18N.getLocaleString("FILTER_APPLY"));
        this.cancel = new JButton(I18N.getLocaleString("MAIN_CANCEL"));
        this.search = new JButton(I18N.getLocaleString("FILTER_SEARCHPACK"));
        this.mcVersion.setPrototypeDisplayValue("xxxxxxxxxxxx");
        this.availability.setPrototypeDisplayValue("xxxxxxxxxxxx");
        panel.add(this.mcVersionLbl);
        panel.add(this.mcVersion);
        panel.add(this.availability);
        panel.add(this.availabilityLbl);
        panel.add(this.apply);
        panel.add(this.cancel);
        panel.add(this.search);
        Spring hSpring = Spring.constant(10);
        layout.putConstraint("West", (Component)this.mcVersionLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.availabilityLbl, hSpring, "West", (Component)panel);
        Spring columnWidth = Spring.max(Spring.width(this.mcVersionLbl), Spring.width(this.availabilityLbl));
        hSpring = SwingUtils.springSum(hSpring, columnWidth, Spring.constant(10));
        layout.putConstraint("West", (Component)this.mcVersion, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.availability, hSpring, "West", (Component)panel);
        columnWidth = Spring.max(Spring.width(this.mcVersion), Spring.width(this.availability));
        hSpring = Spring.sum(hSpring, columnWidth);
        layout.putConstraint("East", (Component)this.mcVersion, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.availability, hSpring, "West", (Component)panel);
        hSpring = Spring.sum(hSpring, Spring.constant(10));
        layout.putConstraint("East", (Component)panel, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.search, 10, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.search, -5, "HorizontalCenter", (Component)panel);
        layout.putConstraint("West", (Component)this.cancel, 5, "HorizontalCenter", (Component)panel);
        layout.putConstraint("East", (Component)this.cancel, -10, "East", (Component)panel);
        layout.putConstraint("West", (Component)this.apply, 10, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.apply, -10, "East", (Component)panel);
        Spring vSpring = Spring.constant(10);
        layout.putConstraint("Baseline", (Component)this.mcVersionLbl, 0, "Baseline", (Component)this.mcVersion);
        layout.putConstraint("North", (Component)this.mcVersion, vSpring, "North", (Component)panel);
        Spring rowHeight = Spring.max(Spring.height(this.mcVersionLbl), Spring.height(this.mcVersion));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(5));
        layout.putConstraint("Baseline", (Component)this.availabilityLbl, 0, "Baseline", (Component)this.availability);
        layout.putConstraint("North", (Component)this.availability, vSpring, "North", (Component)panel);
        rowHeight = Spring.max(Spring.height(this.availabilityLbl), Spring.height(this.availability));
        vSpring = SwingUtils.springSum(vSpring, rowHeight);
        vSpring = Spring.sum(vSpring, Spring.constant(10));
        layout.putConstraint("North", (Component)this.search, vSpring, "North", (Component)panel);
        layout.putConstraint("North", (Component)this.cancel, vSpring, "North", (Component)panel);
        rowHeight = Spring.max(Spring.height(this.search), Spring.height(this.cancel));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(5));
        layout.putConstraint("North", (Component)this.apply, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.apply), Spring.constant(10));
        layout.putConstraint("South", (Component)panel, vSpring, "North", (Component)panel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

